package edu.uky.ai.rl.ex;

import edu.uky.ai.rl.Action;
import edu.uky.ai.rl.Learner;
import edu.uky.ai.rl.Policy;
import edu.uky.ai.rl.State;
import edu.uky.ai.rl.StochasticProcess;
import edu.uky.ai.rl.Transition;

/**
 * A reinforcement learner that simply returns a random policy instead of trying
 * to learn anything about the stochastic process it is given.
 * 
 * @author Your Name
 */
public class ExampleLearner extends Learner {
	
	/**
	 * Constructs a new random reinforcement learning agent. You should change
	 * the string below from "example" to your ID. You should also change the
	 * name of this class. In Eclipse, you can do that easily by right-clicking
	 * on this file (ExampleLearner.java) in the Package Explorer and choosing
	 * Refactor > Rename.
	 */
	public ExampleLearner() {
		super("example");
	}

	@Override
	public Policy learn(StochasticProcess process) {
		// Don't even bother trying to learn anything about the process; just
		// make a policy that chooses a random action every time.
		Policy policy = new RandomPolicy(process.actions);
		// The code below not needed here, but it is included to show you an
		// example of how to interact with the stochastic process.
		// Start in the initial state.
		State current = process.initial;
		// We will transition through the process one complete time (that is,
		// until current#isTerminal() is true. Below is the total score that
		// we earn.
		double score = 0;
		// Keep going until we reach a terminal state or until the search
		// budget runs out.
		while(!current.isTerminal() && !process.budget.hasBeenExhausted()) {
			// Choose an action. This policy chooses an action at random, but
			// your policy should choose more intelligently.
			Action action = policy.choose(current);
			// Find out the result of taking the chosen action in the current
			// state.
			Transition result = process.transition(current, action);
			// This is the new state the process is in.
			current = result.state;
			// This is the reward (or punishment) we got for taking that move.
			score += result.reward;
		}
		// Print out the results.
		System.out.println(this + " scored " + score + " points.");
		// Return the policy.
		return policy;
	}
}
